package com.yaoyaozw.customer.vo.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author darker
 * @date 2022/10/12 11:30
 */
@Data
@ApiModel("文本客服详情实体")
public class CustomerMessageTextDetailVO implements Serializable {

   @JsonSerialize(using = ToStringSerializer.class)
   @ApiModelProperty("主键id")
   private Long id;

   @ApiModelProperty("标题")
   private String name;

   @ApiModelProperty("文本子内容")
   private List<CustomerContentVO> contentList;

   @ApiModelProperty("发文时间")
   private String postTime;

   @ApiModelProperty("发文时间")
   private String type;

}
