package com.yaoyaozw.customer.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.components.CustomerServiceCommonAsyncComponent;
import com.yaoyaozw.customer.constants.CustomerMaterialConstant;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.CustomerFollowReply;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.publisher.AcquisitionExceptionEventPublisher;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.service.wechat.service.WeChatService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wgh
 * @date 2022/10/10 20:04
 */
@Slf4j
@RestController
@RequestMapping("/customer-service/test")
public class TestController {

    private final static String STORE_ENTITY_REDIS_KEY = "STORE_NAME_MAP";

    @Autowired
    private CustomerGraphicsService customerGraphicsService;
    @Autowired
    private AccountOrderService accountOrderService;
    @Autowired
    private CustomerDelayPublishService customerDelayPublishService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;

    @GetMapping("/CustomerTest")
    public void test(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,16);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);
    }

    @GetMapping("/CustomerDelayTest")
    public void delayTest(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,17);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerDelayPublishService.sendCustomerDelayMessage(integrationRequestDTO);
    }

    @GetMapping("/payTest")
    public void payTest(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,12);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    @GetMapping("/putRedisStore")
    public void redisStore() {
        List<AuthInfoVO> allStoreList = kanbanCommonMapper.getAllStoreList();
        Map<String, String> storeMap = allStoreList.stream().collect(Collectors.toMap(AuthInfoVO::getStoreType, AuthInfoVO::getStoreTypeName));
        redisTemplate.opsForHash().putAll(STORE_ENTITY_REDIS_KEY, storeMap);

    }

    @GetMapping("/testFollowReply")
    public void testFollowReply() {
        Object obj = redisTemplate.opsForHash().get(CustomerMaterialConstant.FOLLOW_REPLY_REDIS_KEY, "wx9f460fa46420016c");
        if (ObjectUtil.isNotNull(obj)) {

            List<CustomerFollowReply> list = JSONUtil.toList(JSONUtil.parseArray(obj.toString()), CustomerFollowReply.class);
            for (CustomerFollowReply customerFollowReply : list) {
                System.out.println(customerFollowReply);
            }
        }
    }


    @Resource
    private WeChatService weChatService;
    @Resource
    private RegisterUserEntityService registerUserEntityService;
    @Resource
    private ReferralEntityService referralEntityService;

    @GetMapping("/testSendCustomer")
    public void testSendCustomer() {
        CustomerGraphics entity = customerGraphicsService.getById(1874011792770990080L);

        List<CrowdPackageUserVO> userList = registerUserEntityService.getCurrentInPackUserList(entity.getPackId(), false);

        List<ReferralEntityVo> referralEntityVos = referralEntityService.findReferralByCustomerGraphicsId(entity.getId());

        weChatService.sendCustomerMessage(userList.get(0).getAppId(), entity, userList, referralEntityVos);
    }

    @Autowired
    private CustomerServiceCommonAsyncComponent asyncComponent;

    @GetMapping("/refreshCrowdPackageUserCount")
    public void refreshCrowdPackageUserCount(@RequestParam Long id) {
        asyncComponent.addMatchUserIntoPackage(id, true);
    }


    @Resource
    private AcquisitionExceptionEventPublisher acquisitionExceptionEventPublisher;

    @GetMapping("/testAcquisitionReplace")
    public void testAcquisitionReplace(@RequestParam String linkId) {
        acquisitionExceptionEventPublisher.inspectAndExecute(linkId);
    }

    @GetMapping("/refreshCustomerMaterialSendNum")
    public void refreshCustomerMaterialSendNum() {
        log.info("开始刷新客服消息送达人数...");

        Calendar instance = Calendar.getInstance();
        instance.add(Calendar.DAY_OF_YEAR, -3);
        Date startTime = instance.getTime();

        List<CustomerGraphics> list = customerGraphicsService.list(new QueryWrapper<CustomerGraphics>().between("post_time", startTime, new Date()));
        log.info("开始刷新客服消息送达人数，待处理客服消息数：{}", list.size());

        Map<Object, Object> customerCount = redisTemplate.opsForHash().entries("CUSTOMER_COUNT");
        Map<Long, Integer> map = new HashMap<>();
        for (Map.Entry<Object, Object> objectObjectEntry : customerCount.entrySet()) {
            map.put(Long.valueOf(objectObjectEntry.getKey().toString()), Integer.valueOf(objectObjectEntry.getValue().toString()));
        }

        List<CustomerGraphics> updateList = new ArrayList<>();
        for (CustomerGraphics customerGraphics : list) {
            CustomerGraphics entity = new CustomerGraphics();
            entity.setId(customerGraphics.getId());
            entity.setSendNum(map.getOrDefault(customerGraphics.getId(), 0));
            updateList.add(entity);
        }
        customerGraphicsService.updateBatchById(updateList);
        log.info("刷新客服消息送达人数完成...");
    }

}
