package com.yaoyaozw.customer.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

/**
 * @author darker
 * @date 2023/10/26
 */
@Data
@TableName("customer_follow_reply_multi_news")
public class CustomerFollowReplyMultiNews implements Serializable {
    /**
     * 主键Id
     */
    @TableId(value = "id", type = IdType.ID_WORKER)
    private Long id;

    /**
     * customer_follow_reply 表主键Id
     */
    @TableField("reply_id")
    private Long replyId;

    /**
     * 标题
     */
    @TableField("title")
    private String title;

    /**
     * 图片地址
     */
    @TableField("pic_url")
    private String picUrl;

    /**
     * 链接地址
     */
    @TableField("link_url")
    private String linkUrl;

    /**
     * 逻辑删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 创建人
     */
    @TableField("create_user")
    private Long createUser;

    /**
     * 修改时间
     */
    @TableField("gmt_modified")
    private Date gmtModified;

    /**
     * 修改人
     */
    @TableField("modified_user")
    private Long modifiedUser;

    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private ReferralEntity referralEntity;
}

