package com.yaoyaozw.customer.service.impl;

import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.service.wechat.service.WeChatService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.CustomerDelayPublish;
import com.yaoyaozw.customer.mapper.CustomerDelayPublishMapper;
import com.yaoyaozw.customer.service.CustomerDelayPublishService;

/**
 * 延时客服排期
 * @author wgh
 * @date 2022/9/28 18:51
*/
@Service
public class CustomerDelayPublishServiceImpl extends ServiceImpl<CustomerDelayPublishMapper, CustomerDelayPublish> implements CustomerDelayPublishService{

    private final static String ACCESS_TOKEN_REDIS_KEY = "AUTH_ACCESS_TOKEN";

    private final static Logger localLog = LoggerFactory.getLogger(CustomerDelayPublishServiceImpl.class);

    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private WeChatService weChatService;

    @Autowired
    private RegisterUserEntityService registerUserEntityService;

    @Override
    public void sendCustomerDelayMessage(IntegrationRequestDTO integrationRequestDTO) {
        //读取延时客服排期
        List<CustomerDelayPublish> allPostUser = baseMapper.findPublishUser(integrationRequestDTO.getRequestDate());
        //涉及的appid
        Set<String> appidSet = allPostUser.stream().map(CustomerDelayPublish::getAppId).collect(Collectors.toSet());

        try {
            if (!allPostUser.isEmpty()){
                //号-用户
                Map<String, Map<String,CustomerDelayPublish>> userMap = allPostUser.stream().filter(a->a.getCustomerSort()!=null).collect(Collectors.groupingBy(CustomerDelayPublish::getAppId,Collectors.toMap(CustomerDelayPublish::getOpenId,a->a,(v1,v2)->v1)));
                //获取所有延时客服
                List<CustomerDelayItemVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerSort(appidSet,null);

                if (allDelayCustomerMessage!=null&&!allDelayCustomerMessage.isEmpty()){

                    List<Future<CustomerDelayPublish>>futureList =new ArrayList<>();
                    //号-发送序列-客服id
                    Map<String, Map<Integer, List<CustomerDelayItemVO>>> customerMap =
                            allDelayCustomerMessage.stream().collect(Collectors.groupingBy(CustomerDelayItemVO::getAppId,
                            Collectors.groupingBy(CustomerDelayItemVO::getPostSort)));

                    Set<CustomerDelayItemVO> needUpdateCustomerDelay = new HashSet<>();

                    for (Map.Entry<String,  Map<String,CustomerDelayPublish>> userEntry : userMap.entrySet()) {

                    String appid = userEntry.getKey();
                    //获取该号token
                    Object tokenObject = redisTemplate.opsForHash().get(ACCESS_TOKEN_REDIS_KEY, appid);
                    //没token过滤
                    if (tokenObject==null|| StringUtils.isBlank(tokenObject.toString())){ continue; }
                    //该号下延时客服
                    Map<Integer,List<CustomerDelayItemVO>> delaySortMap = customerMap.get(appid);
                    //所有的用户
                    Map<String,CustomerDelayPublish> userPublishMap = userEntry.getValue();
                    //去重
                    List<CustomerDelayPublish> userList = new ArrayList<>(userPublishMap.values()) ;

                    if (delaySortMap!=null&&!delaySortMap.isEmpty()){
                        //将所有待用延时客服收集
                        for (CustomerDelayPublish userPublish : userList) {
                            //发送延时客服
                            futureList.add(weChatService.sendCustomerDelayMessage(appid,tokenObject.toString(), userPublish, delaySortMap,needUpdateCustomerDelay)) ;
                        }
                    }
                }
                List<CustomerDelayPublish> registerUserEntities = new ArrayList<>();
                //更新下次延时排期
                for (Future<CustomerDelayPublish> delayPublishFuture : futureList) {
                    try {
                        registerUserEntities.add(delayPublishFuture.get()) ;

                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                if (!registerUserEntities.isEmpty()){

                        updateBatchById(registerUserEntities);
                    }
                    //更新延时客服的发送人数数据
                    if (!needUpdateCustomerDelay.isEmpty()){

                        customerGraphicsDelayService.updateSendNumById(needUpdateCustomerDelay);
                    }
                }

            }
        } catch (Exception e) {
            localLog.error("发生异常: {}, 位置: {}", e.getMessage(), e.getStackTrace()[0]);
        }
    }

    @Override
    public void updateExpiredCustomerDelayMessage(Date requestDate) {

        //超时的延时排期
        List<RegisterUserEntity> allExpiredDelayPublish = registerUserEntityService.getAllExpiredDelayPublish(requestDate);

        if(!allExpiredDelayPublish.isEmpty()){
            Set<String> appidList = allExpiredDelayPublish.stream().map(RegisterUserEntity::getAppId).collect(Collectors.toSet());

            //获取所有延时客服
            List<CustomerDelayItemVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerSort(appidList,null);

            Map<String, Map<Long, Integer>> collect = allDelayCustomerMessage.stream().collect(Collectors.groupingBy(CustomerDelayItemVO::getAppId, Collectors.toMap(CustomerDelayItemVO::getTimeInterval, CustomerDelayItemVO::getPostSort, (v1, v2) -> v1)));


            Date currentDate = new Date();

            for (RegisterUserEntity expiredUser : allExpiredDelayPublish) {
                try {
                    Map<Long, Integer> longIntegerMap = collect.get(expiredUser.getAppId());

                    if (longIntegerMap!=null&&!longIntegerMap.isEmpty()){

                        Date firstActive = expiredUser.getFirstActive();

                        ArrayList<Long> timeList = new ArrayList<>(longIntegerMap.keySet());

                        List<Long> sortTimeList = timeList.stream().sorted().collect(Collectors.toList());

                        for (Long aLong : sortTimeList) {

                            Date publishTime = new Date(((firstActive.getTime() + aLong) / 60000) * 60000);

                            if(publishTime.compareTo(currentDate)>0){
                                expiredUser.setCustomerPublish(publishTime);
                                expiredUser.setCustomerSort(longIntegerMap.get(aLong));
                                break;
                            }
                            expiredUser.setCustomerSort(-1);
                        }
                    }else{
                        expiredUser.setCustomerSort(-1);
                    }
                }catch (Exception e){
                    log.error(e.getStackTrace()[0].toString());
                }

            }
            registerUserEntityService.updateBatchById(allExpiredDelayPublish);
        }


    }

}
