package com.yaoyaozw.customer.service;

import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerMessageQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageSaveDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import com.yaoyaozw.customer.vo.customer.CustomerMessageDetailVO;
import com.yaoyaozw.customer.vo.customer.CustomerMessageListVO;

import java.util.List;

/**
 * 客户图形服务
 *
 * @author Admin
 * @date 2022/09/28
 */
public interface CustomerGraphicsService extends IService<CustomerGraphics> {


    /**
     * 插入客户留言
     *
     * @param saveDto 保存dto
     * @return {@link BaseResult}
     */
    BaseResult insertCustomerMessage(CustomerMessageSaveDTO saveDto);


    /**
     * 更新客户信息
     *
     * @param id 客服消息主键
     * @return {@link BaseResult}
     */
    GenericsResult<CustomerMessageDetailVO> getCustomerMessageDetail( Long id);


    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link List}<{@link CustomerDelayListVO}>>
     */
    GenericsResult<PageInfo<CustomerMessageListVO>> pageList(CustomerMessageQueryDTO queryDto);

    /**
     * 删除客户信息
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult removeCustomerMessage(Long id);

    /**
     * 设置包
     *
     * @param id     id
     * @param packId 包id
     * @return {@link BaseResult}
     */
    BaseResult setPack(Long id, Long packId);
}

