package com.yaoyaozw.customer.constants;

import cn.hutool.core.util.ObjectUtil;

/**
 * @author darker
 * @date 2022/9/28 20:09
 */
public class CustomerCommonConstant {

    public final static String CROWD_HUMAN_NUN_REDIS_KEY = "crowdHumanNum";


    public final static Integer BOOK_NEWS_TYPE = 1;
    public final static String BOOK_NEWS_TYPE_NAME = "推广";
    public final static String BOOK_NEWS_TYPE_NAME_MODEL = "系统-客服-{newsType}-{accountNickName}-{storeType}-{currentDate}-{bookName}";

    public final static Integer ACTIVITY_NEWS_TYPE = 2;
    public final static String ACTIVITY_NEWS_TYPE_NAME = "活动";
    public final static String ACTIVITY_NEWS_TYPE_NAME_MODEL = "系统-客服-{newsType}-{accountNickName}-{storeType}-{currentDate}-充{recharge}送{gift}";

    public final static Integer USUAL_LINK_NEWS_TYPE = 3;
    public final static String USUAL_LINK_NEWS_TYPE_NAME = "常用";

    public final static String CUSTOMER_TYPE_VALUE_GRAPHICS = "news";

    public final static String CUSTOMER_TYPE_VALUE_TEXT = "text";

    public final static String CUSTOMER_TYPE_NAME_GRAPHICS = "图文";

    public final static String CUSTOMER_TYPE_NAME_TEXT = "文本";

    public static String getCustomerType(String type) {
        if (ObjectUtil.isNull(type)) {
            return null;
        }
        if (type.equals(CUSTOMER_TYPE_VALUE_GRAPHICS)) {
            return CUSTOMER_TYPE_NAME_GRAPHICS;
        }
        if (type.equals(CUSTOMER_TYPE_VALUE_TEXT)) {
            return CUSTOMER_TYPE_NAME_TEXT;
        }
        return type;
    }

    public static String getNewsTypeName(Integer code) {
        if (ObjectUtil.isNull(code)) {
            return null;
        }
        if (code.equals(BOOK_NEWS_TYPE)) {
            return BOOK_NEWS_TYPE_NAME;
        }
        if (code.equals(ACTIVITY_NEWS_TYPE)) {
            return ACTIVITY_NEWS_TYPE_NAME;
        }
        if (code.equals(USUAL_LINK_NEWS_TYPE)) {
            return USUAL_LINK_NEWS_TYPE_NAME;
        }
        return null;
    }

    public static String getLinkNameModel(Integer code) {
        if (ObjectUtil.isNull(code)) {
            return null;
        }
        if (code.equals(BOOK_NEWS_TYPE)) {
            return BOOK_NEWS_TYPE_NAME_MODEL;
        }
        if (code.equals(ACTIVITY_NEWS_TYPE)) {
            return ACTIVITY_NEWS_TYPE_NAME_MODEL;
        }

        return null;
    }

}
