package com.yaoyaozw.customer.mapper;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @author darker
 * @date 2022/10/9 10:31
 */
@Repository
@DS("material")
public interface MaterialCommonMapper {


    /**
     * 获取存储列表
     *
     * @return {@link List}<{@link CommonOptionResponseVO}>
     */
    List<CommonOptionResponseVO> getStoreList();

    /**
     * 获得身份验证信息列表
     *
     * @param accountSet 帐户设置
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getAuthInfoList(@Param("accountSet") Set<String> accountSet);

}
