package com.yaoyaozw.customer.utils;

import cn.hutool.json.JSONUtil;
import com.yaoyaozw.customer.dto.WeChatTextDTO;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: Dwl
 * @Date: 2024/09/09/12:10
 * @ClassName: WoComUtils
 * @Version: V3.2.0
 * @Description:
 */
@Slf4j
public class WeChatUtils {
    private static final String WO_COM_API_URL = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send";

    private static Map<String, String> getParams(String key) {
        Map<String, String> headers = new HashMap<>();
        headers.put("key", key);
        return headers;
    }

    public static void sendErrorMessage(String message, String key) {
        Map<String, String> params = getParams(key);
        try {
            String s = HttpClientUtil.allElementPost(WO_COM_API_URL, message, params, null, String.class);
        } catch (Exception e) {
            log.error("sendErrorMessage error: {}", e.getMessage());
        }
    }

    public static void sendErrorMessage(WeChatTextDTO woComDTO, String key) {
        sendErrorMessage(JSONUtil.toJsonStr(woComDTO), key);
    }
}
