package com.yaoyaozw.customer.mapper;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;


@DS("material")
@Mapper
public interface CustomerGraphicsDelayMapper extends BaseMapper<CustomerGraphicsDelay> {
    /**
     * 根据appid找延时客服
     *
     * @param appidList
     * @return
     */
    List<CustomerDelayItemVO> findAllDelayCustomerMessage(@Param("appidList") Set<String> appidList);

    List<CustomerDelayItemVO> findDelayCustomerMessageByRange(@Param("appidList") Set<String> appidList, @Param("maxSort") Integer maxSort);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link List}<{@link CustomerDelayListVO}>
     */
    List<CustomerDelayListVO> pageList(CustomerDelayQueryDTO queryDto);

    /**
     * 得到客户账户存在
     *
     * @param keyword 关键字
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getExistCustomerAccount(@Param("keyword") String keyword);

    /**
     * 让时间间隔列表
     *
     * @param keyword 关键词
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getAuthList(@Param("keyword") String keyword);

    /**
     * 让时间间隔列表
     *
     * @return {@link List}<{@link CommonOptionResponseVO}>
     */
    List<CommonOptionResponseVO> getTimeIntervalList();

}