package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageConditionDTO;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.entity.CrowdPackageCondition;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.mapper.MaterialCrowdPackageMapper;
import com.yaoyaozw.customer.service.CrowdPackageConditionService;
import com.yaoyaozw.customer.service.CrowdPackageService;
import com.yaoyaozw.customer.vo.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageCommonIdVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageConditionVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageDetailVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author darker
 * @date 2022/9/16 12:03
 */
@Service
public class CrowdPackageServiceImpl extends ServiceImpl<MaterialCrowdPackageMapper, CrowdPackage> implements CrowdPackageService {

    @Autowired
    private CrowdPackageConditionService conditionService;
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;


    @Override
    public GenericsResult<CrowdPackageCommonIdVO> insertCrowdPackage(String name) {
        return null;
    }

    @Override
    public GenericsResult<CrowdPackageCommonIdVO> insertCondition(CrowdPackageConditionDTO conditionDto) {
        return null;
    }

    @Override
    public GenericsResult<List<CrowdPackageListVO>> pageList(CrowdPackageQueryDTO queryDto) {

        return null;
    }

    @Override
    public BaseResult removeCrowdPackage(Long id) {
        return null;
    }

    @Override
    public BaseResult removeCondition(Long linkedId) {
        return null;
    }

    @Override
    public GenericsResult<CrowdPackageDetailVO> getPackageInfo(Long id) {
        return null;
    }

    @Override
    public GenericsResult<List<CrowdPackageConditionVO>> getAllConditions() {
        List<CrowdPackageCondition> conditionList = conditionService.list();
        // 将结果转换成返回结果
        List<CrowdPackageConditionVO> conditionVoList = conditionList.stream().map(item -> {
            CrowdPackageConditionVO vo = new CrowdPackageConditionVO();
            BeanUtils.copyProperties(item, vo);
            return vo;
        }).collect(Collectors.toList());
        // 封装返回结果
        return new GenericsResult<>(conditionVoList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getOptions(Long conditionId) {
        // 查出该条件的数据
        CrowdPackageCondition conditionItem = conditionService.getById(conditionId);
        if (ObjectUtil.isNull(conditionItem)) {
            return new GenericsResult<>(Boolean.FALSE, CrowdPackageCommonConstant.CANT_FIND_ITEM, null);
        }
        if (ObjectUtil.isNull(conditionItem.getSourceBaseService())) {
            return new GenericsResult<>(Boolean.FALSE, CrowdPackageCommonConstant.CANT_FIND_DATA_BASE_CONFIG, null);
        }
        // 根据条件配置判断查询的数据库
        List<CommonOptionResponseVO> result;
        if (CrowdPackageCommonConstant.KANBAN_DATA_BASE.equals(conditionItem.getSourceBaseService())) {
            // 是看板的数据源
            result = kanbanCommonMapper.getConditionOptionByConfig(conditionItem);
        } else if (CrowdPackageCommonConstant.MATERIAL_DATA_BASE.equals(conditionItem.getSourceBaseService())) {
            // 是运营系统的数据源
            result = baseMapper.getConditionOptionByConfig(conditionItem);
        } else {
            return new GenericsResult<>(Boolean.FALSE, CrowdPackageCommonConstant.UNKNOWN_DATA_BASE_CONFIG, null);
        }

        return new GenericsResult<>(result);
    }

}
