package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageConditionDTO;
import com.yaoyaozw.customer.service.CrowdPackageService;
import com.yaoyaozw.customer.vo.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageCommonIdVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageConditionVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageDetailVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 14:08
 */
@Api(tags = "人群包接口")
@RestController
@RequestMapping("/crowd-package")
public class CrowdPackageController {

    @Autowired
    private CrowdPackageService crowdPackageService;


    @ApiOperation("新增人群包")
    @GetMapping("/insertPackage/{name}")
    public GenericsResult<CrowdPackageCommonIdVO> insertCrowdPackage(@PathVariable("name")String name) {
        return crowdPackageService.insertCrowdPackage(name);
    }

    @ApiOperation("新增包内条件")
    @PostMapping("/insertCondition")
    public GenericsResult<CrowdPackageCommonIdVO> insertCondition(@RequestBody CrowdPackageConditionDTO conditionDto) {
        return crowdPackageService.insertCondition(conditionDto);
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<CrowdPackageListVO>> pageList(@RequestBody CrowdPackageQueryDTO queryDto) {
        return crowdPackageService.pageList(queryDto);
    }

    @ApiOperation("删除人群包")
    @GetMapping("/removePackage/{id}")
    public BaseResult removeCrowdPackage(@PathVariable("id") Long id) {
        return crowdPackageService.removeCrowdPackage(id);
    }

    @ApiOperation("删除包内条件")
    @GetMapping("/removePackage/{linkedId}")
    public BaseResult removeCondition(@PathVariable("linkedId") Long linkedId) {
        return crowdPackageService.removeCondition(linkedId);
    }

    @ApiOperation("获取已配置的人群包条件")
    @GetMapping("/getPackageInfo/{id}")
    public GenericsResult<CrowdPackageDetailVO> getPackageInfo(@PathVariable("id") Long id) {
        return crowdPackageService.getPackageInfo(id);
    }

    @ApiOperation("获取所有条件下拉框")
    @GetMapping("/getAllConditions")
    public GenericsResult<List<CrowdPackageConditionVO>> getAllConditions() {
        return crowdPackageService.getAllConditions();
    }

    @ApiOperation("获取条件的可选项")
    @GetMapping("/getOptions/{conditionId}")
    public GenericsResult<List<CommonOptionResponseVO>> getOptions(@PathVariable("conditionId") Long conditionId) {
        return crowdPackageService.getOptions(conditionId);
    }



}
