package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.mapper.ReferralEntityMapper;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author didi
 * @Create 2022/3/23 16:14
 */
@Service
public class ReferralEntityServiceImpl extends ServiceImpl<ReferralEntityMapper, ReferralEntity> implements ReferralEntityService {

    @Override
    public void ultimateDeleteReferrals(Long materialId, String extraCondition) {
        if (ObjectUtil.isNull(materialId)) {
            return;
        }
        super.baseMapper.ultimateDeleteReferrals(materialId, extraCondition);
    }

    @Override
    public void ultimateDeleteReferralsBatch(List<Long> sourceIdList, String extraCondition) {
        if (CollectionUtil.isEmpty(sourceIdList)) {
            return;
        }
        super.baseMapper.ultimateDeleteReferralsBatch(sourceIdList, extraCondition);
    }

    @Override
    public List<ReferralEntityVo> findReferralByCustomerGraphicsId(Long graphicsId) {
        return baseMapper.findByMaterialGraphicsId(graphicsId);
    }

}
