package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.follow.FollowReplyCopyDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.dto.follow.FollowReplyQueryDTO;
import com.yaoyaozw.customer.dto.follow.FollowReplySaveDTO;
import com.yaoyaozw.customer.service.CustomerFollowReplyService;
import com.yaoyaozw.customer.vo.follow.FollowReplyInfoVO;
import com.yaoyaozw.customer.vo.follow.FollowReplyListVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author darker
 * @date 2023/3/13 19:47
 */
@RestController
@RequestMapping("/follow-reply")
public class FollowReplyController {

    @Autowired
    private CustomerFollowReplyService followReplyService;


    @PostMapping("/list")
    public GenericsResult<List<FollowReplyListVO>> list(@RequestBody FollowReplyQueryDTO queryDto) {
        return followReplyService.list(queryDto);
    }

    @PostMapping("/create")
    @OperateLog(module = "客服-关回", desc = "创建素材")
    public GenericsResult<String> create(@RequestBody @Validated FollowReplySaveDTO saveDto) {
        return followReplyService.create(saveDto);
    }

    @PostMapping("/createTextItem")
    @OperateLog(module = "客服-关回", desc = "创建文本子素材")
    public GenericsResult<List<CommonReferralBody>> createTextItem(@RequestBody CommonReferralBody referralBody) {
        return followReplyService.createTextItem(referralBody);
    }

    @GetMapping("/info/{id}")
    public GenericsResult<FollowReplyInfoVO> getInfo(@PathVariable("id") Long id) {
        return followReplyService.getInfo(id);
    }

    @GetMapping("/remove/{id}")
    @OperateLog(module = "客服-关回", desc = "删除素材")
    public BaseResult remove(@PathVariable("id") Long id) {
        return followReplyService.remove(id);
    }

    @GetMapping("/removeTextItem/{id}")
    @OperateLog(module = "客服-关回", desc = "删除文本子素材")
    public GenericsResult<List<CommonReferralBody>> removeTextItem(@PathVariable("id") Long id) {
        return followReplyService.removeTextItem(id);
    }

    @PostMapping("/copy")
    @OperateLog(module = "客服-关回", desc = "关回复用")
    public BaseResult copy(@RequestBody FollowReplyCopyDTO copyDto) {
        return followReplyService.copy(copyDto);

    }

}
