package com.yaoyaozw.customer.controller;

import cn.hutool.core.util.ObjectUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.service.AccountOrderService;
import com.yaoyaozw.customer.service.CustomerDelayPublishService;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Calendar;

/**
 * @author wgh
 * @date 2022/10/10 20:04
 */
@Slf4j
@RestController
@RequestMapping("/customer-service/test")
public class TestController {

    @Autowired
    private CustomerGraphicsService customerGraphicsService;
    @Autowired
    private AccountOrderService accountOrderService;
    @Autowired
    private CustomerDelayPublishService customerDelayPublishService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @GetMapping("/CustomerTest")
    public void test(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,16);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);
    }

    @GetMapping("/CustomerDelayTest")
    public void delayTest(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,17);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        customerDelayPublishService.sendCustomerDelayMessage(integrationRequestDTO);
    }

    @GetMapping("/payTest")
    public void payTest(){

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM,0);
        calendar.set(Calendar.HOUR,12);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();
        integrationRequestDTO.setRequestDate(calendar.getTime());
        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    @GetMapping("/ygLimit")
    public void ygLimit(){

        limit();

    }

    private void limit() {
        boolean go;
        synchronized (rabbitTemplate) {
            // 从redis查询计数
            Object count = redisTemplate.opsForValue().get(CustomerCommonConstant.YANG_GUANG_ACCESS_LIMIT_REDIS_KEY);
            if (ObjectUtil.isNull(count)) {
                // redis中没有，设置0
                redisTemplate.opsForValue().set(CustomerCommonConstant.YANG_GUANG_ACCESS_LIMIT_REDIS_KEY, 0);
                count = 0;
            }

            log.info("当前count: {}", count);
            long stamp = System.currentTimeMillis();
            // 判断计数是否达到上限
            go = (Integer)count < 80;

            if (go) {
                // 没有达到上限，发送消息并且计数加1
                rabbitTemplate.convertAndSend("TTL_EXCHANGE", "yg_limit", stamp);
                redisTemplate.opsForValue().increment(CustomerCommonConstant.YANG_GUANG_ACCESS_LIMIT_REDIS_KEY);
            }
        }
        if (!go) {
            // 计数达到上限了，休眠30秒，递归调用
            try {
                log.info("达到上限, 休眠1分钟");
                Thread.sleep(60000);
                limit();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

    }

    @RabbitListener(queues = "DEATH_QUEUE")
    public void listener() {
        redisTemplate.opsForValue().decrement(CustomerCommonConstant.YANG_GUANG_ACCESS_LIMIT_REDIS_KEY);
    }

}
