package com.yaoyaozw.customer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface RegisterUserEntityMapper extends BaseMapper<RegisterUserEntity> {

    /**
     * 获取符合动态条件的用户
     *
     * @param dynamicExpressList 动态表达列表
     * @param openId             指定openId
     * @return {@link List}<{@link RegisterUserEntity}>
     */
    List<CrowdPackageUserVO> getUserMatchDynamicExpress(@Param("dynamicExpressList") List<String> dynamicExpressList, @Param("openId") String openId);

    /**
     * 更新用户所属人群包
     *
     * @param openId        用户 openId
     * @param packageBelong 所属人群包
     */
    void updateUserPackageBelong(@Param("openId") String openId, @Param("packageBelong") String packageBelong);

}