package com.yaoyaozw.customer.service.wechat.service;


import com.yaoyaozw.customer.entity.CustomerDelayPublish;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.service.wechat.entity.WeChatResponseEntity;
import com.yaoyaozw.customer.service.wechat.entity.customerRequest.CustomerNewsArticleItem;
import com.yaoyaozw.customer.service.wechat.entity.customerRequest.CustomerNewsItem;
import com.yaoyaozw.customer.service.wechat.entity.customerRequest.WeChatCustomerRequestEntity;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

@Service
public class WeChatServiceImpl implements WeChatService{

    private String customerPath="";

    private static final String CUSTOMER_TEXT="text";

    private static final String CUSTOMER_NEWS="news";

    @Autowired
    private WeChatRestService weChatRestService;

    @Async("myExecutor")
    @Override
    public Future<CustomerDelayPublish> sendCustomerDelayMessage(String token, CustomerDelayPublish user, Map<Integer,CustomerDelayItemVO> delaySortMap) {
        //当前时间批次发文素材的用户关注时间一致
        Long subscribeTimestamp = user.getGmtCreate().getTime();

        Integer newSort = user.getCustomerSort()+1;

        CustomerDelayItemVO customerDelayItemVO = delaySortMap.get(newSort);

        if (customerDelayItemVO!=null&&customerDelayItemVO.getTimeInterval()!=null){

            user.setCustomerSort(newSort);

            user.setCustomerPublish(new Date(subscribeTimestamp+customerDelayItemVO.getTimeInterval()));
        }
        return new AsyncResult<>(user);
    }


    @Override
    public void sendCustomerMessage(String appid,String token, CustomerGraphics customerGraphics, List<CrowdPackageUserVO> openidList,List<ReferralEntityVo> referralEntityVo) {
        //根据公众号发送客服
        String fullPath=customerPath+"?"+token;
        //构建请求参数（文本/图文）
        WeChatCustomerRequestEntity customerRequest = buildCustomerRequest(customerGraphics,referralEntityVo);
        try {
            ResponseEntity<WeChatResponseEntity> response = weChatRestService.sendPostRequest(fullPath, WeChatResponseEntity.class, customerRequest);

            WeChatResponseEntity body = response.getBody();

            System.err.println(body);

        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

    }


    private WeChatCustomerRequestEntity buildCustomerRequest(CustomerGraphics customerGraphics,List<ReferralEntityVo> urlList){
        //类型判断

        if (CUSTOMER_TEXT.equals(customerGraphics.getType())){

            return new WeChatCustomerRequestEntity(CUSTOMER_TEXT,customerGraphics.getContent());

        }else if (CUSTOMER_NEWS.equals(customerGraphics.getType())){

            return new WeChatCustomerRequestEntity(CUSTOMER_NEWS,customerGraphics.getExtendTitle(),urlList.get(0).getReferral(),customerGraphics.getContent(),customerGraphics.getCoverUrl());

        }

        return null;
    }
}
