package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.CustomerServiceCommonAsyncComponent;
import com.yaoyaozw.customer.components.SnowflakeComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerMessageQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageSaveDTO;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.entity.CrowdPackageCondition;
import com.yaoyaozw.customer.entity.CrowdPackageConditionMatch;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.service.CrowdPackageConditionMatchService;
import com.yaoyaozw.customer.service.CrowdPackageConditionService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.vo.customer.CustomerMessageDetailVO;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.service.wechat.service.WeChatService;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.customer.CustomerMessageListVO;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.mapper.CustomerGraphicsMapper;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

/**
 * 客户图形服务impl
 *
 * @author Admin
 * @date 2022/09/28
 */
@Service
public class CustomerGraphicsServiceImpl extends ServiceImpl<CustomerGraphicsMapper, CustomerGraphics> implements CustomerGraphicsService {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CustomerGraphicsServiceImpl.class);

    @Autowired
    private CrowdPackageConditionMatchService matchService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private CustomerServiceCommonAsyncComponent commonAsyncComponent;
    @Autowired
    private ReferralEntityService referralEntityService;
    @Autowired
    private WeChatService weChatService;
    @Autowired
    private RegisterUserEntityService registerUserEntityService;
    @Autowired
    private AuthorizerTokenService authorizerTokenService;

    @Autowired
    private CrowdPackageConditionService conditionService;
    @Autowired
    private SnowflakeComponent snowflakeComponent;
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;

    @Override
    public BaseResult insertCustomerMessage(CustomerMessageSaveDTO saveDto) {

        // 主体数据
        LOCAL_LOG.info("处理主体数据");
        CustomerGraphics customerGraphics = new CustomerGraphics();
        BeanUtil.copyProperties(saveDto, customerGraphics);
        customerGraphics.initOperateInfo(tokenManager.getUserIdFromToken(), ObjectUtil.isNull(saveDto.getId()));
        if (ObjectUtil.isNull(customerGraphics.getId())) {
            long id = snowflakeComponent.snowflakeId();
            customerGraphics.setId(id);
        }
        super.saveOrUpdate(customerGraphics);

        // 处理活动数据
        ReferralEntity referralEntity = new ReferralEntity();
        BeanUtil.copyProperties(saveDto.getCustomerReferralDto(), referralEntity);
        referralEntity.setMaterialGraphicsId(customerGraphics.getId());


        // 保存链接数据
        referralEntityService.saveOrUpdate(referralEntity);
        return new BaseResult().success();
    }

    @Override
    public GenericsResult<CustomerMessageDetailVO> getCustomerMessageDetail(Long id) {

        // 获取主体数据
        CustomerGraphics customerGraphics = super.getById(id);
        if (ObjectUtil.isNull(customerGraphics)) {
            return new GenericsResult<>(false, "找不到主体数据");
        }
        CustomerMessageDetailVO customerMessageDetailVO = new CustomerMessageDetailVO();
        BeanUtil.copyProperties(customerGraphics, customerMessageDetailVO);

        // 获取链接数据
        ReferralEntity referralEntity = referralEntityService.getOne(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", id).isNull("account_id"));
        CustomerReferralDTO customerReferralDto = new CustomerReferralDTO();

        if (ObjectUtil.isNull(referralEntity)) {
            return new GenericsResult<>(false, "找不到链接数据");
        }
        BeanUtil.copyProperties(referralEntity, customerReferralDto);
        customerMessageDetailVO.setCustomerReferralDto(customerReferralDto);

        return new GenericsResult<>(customerMessageDetailVO);
    }

    @Override
    public GenericsResult<PageInfo<CustomerMessageListVO>> pageList(CustomerMessageQueryDTO queryDto) {
        PageHelper.startPage(queryDto.getCurrentPage(), queryDto.getPageSize());
        List<CustomerMessageListVO> list = baseMapper.pageList(queryDto);
        PageInfo<CustomerMessageListVO> pageList = new PageInfo<>(list);
        return new GenericsResult<>(pageList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResult removeCustomerMessage(Long id) {
        boolean result = super.removeById(id);
        boolean referralResult = referralEntityService.remove(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", id));
        if (result && referralResult) {
            // 删除成功
            return new BaseResult().success();
        }
        LOCAL_LOG.info("主体删除结果: {}, 链接删除结果: {}, 删除失败，回滚事务", result, referralResult);
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return new BaseResult().error("删除异常");
    }

    @Override
    public BaseResult setPack(Long id, Long packId) {
        CustomerGraphics byId = super.getById(id);
        if (ObjectUtil.isNull(byId)) {
            return new BaseResult().error("无法获取主体数据");
        }
        byId.setPackId(packId);
        ReferralEntity referralEntity = referralEntityService.getOne(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", id).isNull("account_id"));

        LOCAL_LOG.info("获取书城条件主体");
        CrowdPackageCondition storeCondition = conditionService.getOne(
                new QueryWrapper<CrowdPackageCondition>().eq("condition_key", CrowdPackageCommonConstant.CONDITION_STORE_ID).eq("front_type", CrowdPackageCommonConstant.MULTIPLE_SELECT)
        );
        // TODO: 2022/10/8 校验人群包设置条件
        LOCAL_LOG.info("获取人群包下的书城条件");
        CrowdPackageConditionMatch storeConditionMatch = matchService.getOne(
                new QueryWrapper<CrowdPackageConditionMatch>().eq("package_id", packId).eq("condition_id", storeCondition.getId())
        );
        Integer newsType = referralEntity.getNewsType();
        if (CustomerCommonConstant.BOOK_NEWS_TYPE.equals(newsType)) {
            // 是推广链接
            BaseResult checkResult = this.checkExtendBook(referralEntity.getStoreType(), storeConditionMatch);
            if (!checkResult.getSuccess()) {
                return checkResult;
            }
        }
        // TODO: 2022/10/8 根据人群包条件获取用户公众号，生成链接


        byId.setPackId(packId);
        boolean result = super.updateById(byId);
        if (result) {
            return new BaseResult().success();
        }
        return new BaseResult().error("更新失败");
    }

    @Override
    public void sendCustomerMessage(IntegrationRequestDTO integrationRequestDTO) {

        Date requestDate = integrationRequestDTO.getRequestDate();

        //当前时刻发送的客服（需要加启用禁用）
        List<CustomerGraphics> customerGraphicsList = list(new QueryWrapper<CustomerGraphics>().eq(CustomerGraphics.COL_POST_TIME, requestDate));

        for (CustomerGraphics customerGraphics : customerGraphicsList) {

            Long packId = customerGraphics.getPackId();

            /*
            根据人群包找人
             */
            List<CrowdPackageUserVO> userList=new ArrayList<>();


            Map<String, List<CrowdPackageUserVO>> appidUserMap = userList.stream().collect(Collectors.groupingBy(CrowdPackageUserVO::getAppId));

            //根据公众号找具体素材和链接
            List<ReferralEntityVo> referralList = referralEntityService.findReferralByCustomerGraphicsId(customerGraphics.getId());

            Map<String, List<ReferralEntityVo>> referralMap = referralList.stream().collect(Collectors.groupingBy(ReferralEntityVo::getAppid));
            //循环该客服下的所有素材
            for (Map.Entry<String, List<ReferralEntityVo>> referralEntry : referralMap.entrySet()) {

                String appid = referralEntry.getKey();
                //获取token
                AuthorizerToken authorizerToken = authorizerTokenService.findTokenByAppid(appid);

                if (authorizerToken!=null&&authorizerToken.getAuthorizerAccessToken()!=null){
                    //获取该号的链接实体
                    List<ReferralEntityVo> referralEntityVo = referralMap.get(appid);
                    //获取该号的openid
                    List<CrowdPackageUserVO> packageUserVo = appidUserMap.get(appid);

                    if (referralEntityVo!=null&&!referralEntityVo.isEmpty()){

                        weChatService.sendCustomerMessage(appid,authorizerToken.getAuthorizerAccessToken(),customerGraphics,packageUserVo,referralEntityVo);
                    }
                }
            }
        }
    }

    private BaseResult checkExtendBook(String storeType, CrowdPackageConditionMatch storeConditionMatch) {
        // 判断有没有选书城条件
        if (ObjectUtil.isNull(storeConditionMatch)) {
            // 没有的话不符合条件，返回
            return new BaseResult().error("所选人群包未设置书城条件");
        }
        String operatorExpression = storeConditionMatch.getOperatorExpression();
        // 判断选了几个书城，如果超过1个，则不符合条件
        if (operatorExpression.contains(CrowdPackageCommonConstant.COMMA_SEPARATOR)) {
            // 只要表达式包含了逗号，就说明选了不止一个书城条件
            return new BaseResult().error("所选人群包设置的书城条件超过1个");
        }
        // 确定只选了一个书城，判断设置的书是不是这个书城里的
        LOCAL_LOG.info("原始书城条件表达式: {}", operatorExpression);
        operatorExpression = "where " + operatorExpression.replace(CrowdPackageCommonConstant.CONDITION_STORE_ID, "id");
        LOCAL_LOG.info("新的书城条件表达式: {}", operatorExpression);
        String storeTypeByExpression = kanbanCommonMapper.getStoreTypeByExpression(operatorExpression);
        LOCAL_LOG.info("表达式获取到的书城: {}", storeTypeByExpression);

        if (storeType.equals(storeTypeByExpression)) {
            return new BaseResult().success();
        }
        return new BaseResult().error("所选书籍不属于人群包指定书城");

    }


}

