package com.yaoyaozw.customer.constants;

import cn.hutool.core.util.ObjectUtil;

/**
 * @author darker
 * @date 2022/9/28 20:09
 */
public class CustomerCommonConstant {

    public final static String CROWD_HUMAN_NUN_REDIS_KEY = "crowdHumanNum";

    public final static Integer ACTIVITY_NEWS_TYPE = 8;

    public final static Integer BOOK_NEWS_TYPE = 7;

    public final static Integer USUAL_LINK_NEWS_TYPE = 9;

    public final static String CUSTOMER_TYPE_VALUE_GRAPHICS = "news";

    public final static String CUSTOMER_TYPE_VALUE_TEXT = "text";

    public final static String CUSTOMER_TYPE_NAME_GRAPHICS = "图文";

    public final static String CUSTOMER_TYPE_NAME_TEXT = "文本";

    public static String getCustomerType(String type) {
        if (ObjectUtil.isNull(type)) {
            return null;
        }
        if (type.equals(CUSTOMER_TYPE_VALUE_GRAPHICS)) {
            return CUSTOMER_TYPE_NAME_GRAPHICS;
        }
        if (type.equals(CUSTOMER_TYPE_VALUE_TEXT)) {
            return CUSTOMER_TYPE_NAME_TEXT;
        }
        return type;
    }

}
