package com.yaoyaozw.customer.vo.crowd;

import com.yaoyaozw.customer.vo.CommonOptionResponseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/21 19:34
 */
@Data
@ApiModel("条件选项实体")
@NoArgsConstructor
public class ConditionOptionResponseVO implements Serializable {

    @ApiModelProperty("条件类型")
    private String frontType;

    @ApiModelProperty("选项列表")
    private List<CommonOptionResponseVO> optionList;

    public ConditionOptionResponseVO(String frontType, List<CommonOptionResponseVO> optionList) {
        this.frontType = frontType;
        this.optionList = optionList;
    }
}
