package com.yaoyaozw.customer.service.wechat.entity.customerRequest;

import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wgh
 * @date 2022/10/8 19:04
 */

@Data
public class WeChatCustomerRequestEntity implements Serializable {

    private String touser;

    private String msgtype;

    private CustomerNewsItem news;

    private CustomerTextItem text;

    private CustomerMiniProgramItem miniprogrampage;

    public WeChatCustomerRequestEntity( String msgtype, String title, String description, String url, String picurl) {

        this.msgtype = msgtype;
        this.news = new CustomerNewsItem(new CustomerNewsArticleItem(title,description,url,picurl));
    }

    public WeChatCustomerRequestEntity(String msgtype, String content) {

        this.msgtype = msgtype;
        this.text = new CustomerTextItem(content);
    }

    public static WeChatCustomerRequestEntity miniProgram(String title, String appId, String path, String mediaId) {
        WeChatCustomerRequestEntity weChatCustomerRequestEntity = new WeChatCustomerRequestEntity();
        weChatCustomerRequestEntity.setMsgtype(CustomerCommonConstant.CUSTOMER_TYPE_VALUE_MINI_PROGRAM);
        weChatCustomerRequestEntity.setMiniprogrampage(
                new CustomerMiniProgramItem(title, appId, path, mediaId)
        );

        return weChatCustomerRequestEntity;
    }


    public WeChatCustomerRequestEntity() {
    }
}
