package com.yaoyaozw.customer.vo.crowd;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/16 10:46
 */
@Data
@ApiModel("人群包列表实体")
public class CrowdPackageListVO implements Serializable {

    @ApiModelProperty("人群包主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("人群包名称")
    private String packageName;

    @ApiModelProperty("人群包标签")
    private String packageLabel;

    @ApiModelProperty("人群包中的人数")
    private Integer numOfCrowdInPackage;

    @ApiModelProperty("最后一次统计时间")
    private String lastCountTime;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("修改时间")
    private String modifiedTime;

    @ApiModelProperty("修改人")
    private String modifiedUser;

    public String getPackageLabel() {
        if (ObjectUtil.isNull(this.packageLabel)) {
            return null;
        }
        return packageLabel.replaceAll(",", "<br/>");
    }
}
