package com.yaoyaozw.customer.mapper;

import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.CompanyAcquisitionLink;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface CompanyAcquisitionLinkMapper {

    /**
     * 根据链接Id获取获客链接信息
     * @param linkId 链接Id
     * @return 获客链接信息
     */
    CompanyAcquisitionLink getAcquisitionInfoByLinkId(@Param("linkId") String linkId);

    /**
     * 获取指定appId的获客链接列表
     *
     * @param appId        appId
     * @param exceptLinkId 排除的链接Id
     * @param type 限定类型
     * @return 可使用链接列表
     */
    List<CompanyAcquisitionLink> getAvailableAcquisitionListExceptLinkId(@Param("appId") String appId, @Param("exceptLinkId") String exceptLinkId, @Param("type") String type);


}
