package com.yaoyaozw.customer.vo.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/10/8 17:13
 */
@Data
public class CustomerMessageDetailVO implements Serializable {

    @ApiModelProperty("客服消息id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("标题")
    private String name;

    @ApiModelProperty("消息发送时间")
    private String postTime;

    @ApiModelProperty("是否支付 0-否 1-是")
    private Integer isPay;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String type;

    @ApiModelProperty("素材文本内容")
    private String extendTitle;

    @ApiModelProperty("素材图片路径")
    private String coverUrl;

    @ApiModelProperty("素材文本内容")
    private String content;

    @ApiModelProperty("链接相关内容")
    private CustomerReferralDTO customerReferralDto;

}
