package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.SnowflakeComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.mapper.CustomerGraphicsDelayMapper;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.service.AuthorizerInfoService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayGraphicsDetailVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Service
public class CustomerGraphicsDelayServiceImpl extends ServiceImpl<CustomerGraphicsDelayMapper, CustomerGraphicsDelay> implements CustomerGraphicsDelayService {

    private final static Logger localLog = LoggerFactory.getLogger(CustomerGraphicsDelayServiceImpl.class);

    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private SnowflakeComponent snowflakeComponent;
    @Autowired
    private ReferralEntityService referralEntityService;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;


    @Override
    public List<CustomerDelayItemVO> findAllDelayCustomerMessage(Set<String> appidList,Integer maxSortRange) {

        if (maxSortRange!=null){

            return baseMapper.findDelayCustomerMessageByRange(appidList,maxSortRange);
        }else{

            return baseMapper.findAllDelayCustomerMessage(appidList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResult insertCustomerDelay(CustomerDelaySaveDTO saveDto) {

        CustomerGraphicsDelay customerGraphicsDelay = new CustomerGraphicsDelay();
        BeanUtil.copyProperties(saveDto, customerGraphicsDelay);
        // 初始化操作信息
        customerGraphicsDelay.initOperateInfo(tokenManager.getUserIdFromToken(), ObjectUtil.isNull(saveDto.getId()));
        if (ObjectUtil.isNull(customerGraphicsDelay.getId())) {
            long id = snowflakeComponent.snowflakeId();
            localLog.info("是新增, 新生成ID: {}", id);
            customerGraphicsDelay.setId(id);
        }

        customerGraphicsDelay.setSendStatus(CustomerCommonConstant.SEND_STATUS_LINK_GETTING);
        boolean mainResult = super.saveOrUpdate(customerGraphicsDelay);
        if (!mainResult) {
            localLog.info("主体数据生成异常");
            return new BaseResult().error("新增/更新 主体数据异常");
        }

        localLog.info("生成referral数据");
        ReferralEntity referralEntity = new ReferralEntity();
        referralEntity.setMaterialGraphicsId(customerGraphicsDelay.getId());
        BeanUtil.copyProperties(referralEntity, saveDto.getCustomerReferralDto());

        boolean referralResult = referralEntityService.saveOrUpdate(referralEntity);
        if (!referralResult) {
            localLog.info("referral数据生成异常, 回滚事务");
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        // TODO: 2022/10/14 生成链接

        return new BaseResult().success();
    }

    @Override
    public GenericsResult<CustomerDelayGraphicsDetailVO> getCustomerDelayDetail(Long id) {
        CustomerGraphicsDelay customerGraphicsDelay = super.getById(id);
        if (ObjectUtil.isNull(customerGraphicsDelay)) {
            return new GenericsResult<>(false, "找不到主体数据");
        }
        CustomerDelayGraphicsDetailVO customerDelayGraphicsDetailVO = new CustomerDelayGraphicsDetailVO();
        BeanUtil.copyProperties(customerGraphicsDelay, customerDelayGraphicsDetailVO);

        // 查询链接数据
        ReferralEntity referralEntity = referralEntityService.getOne(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", id));

        if (ObjectUtil.isNull(referralEntity)) {
            return new GenericsResult<>(false, "找不到链接数据");
        }
        CustomerReferralDTO customerReferralDto = new CustomerReferralDTO();
        BeanUtil.copyProperties(referralEntity, customerReferralDto);

        customerDelayGraphicsDetailVO.setCustomerReferralDto(customerReferralDto);

        return new GenericsResult<>(customerDelayGraphicsDetailVO);
    }

    @Override
    public GenericsResult<PageInfo<CustomerDelayListVO>> pageList(CustomerDelayQueryDTO queryDto) {
        PageHelper.startPage(queryDto.getCurrentPage(), queryDto.getPageSize());
        List<CustomerDelayListVO> customerDelayList = super.baseMapper.pageList(queryDto);
        PageInfo<CustomerDelayListVO> pageResult = new PageInfo<>(customerDelayList);

        return new GenericsResult<>(pageResult);
    }

    @Override
    public GenericsResult<List<AuthInfoVO>> getExistCustomerAccount(String keyword) {
        List<AuthInfoVO> existCustomerAccount = super.baseMapper.getExistCustomerAccount(keyword);
        return new GenericsResult<>(existCustomerAccount);
    }

    @Override
    public BaseResult removeCustomerDelay(Long id) {
        return null;
    }

    @Override
    public BaseResult removeBatch(List<Long> idList) {
        return null;
    }

    @Override
    public BaseResult copy(String appId, List<String> targetAppList) {
        List<AuthorizerInfo> authorizerInfoList = authorizerInfoService.list();
        Map<String, AuthorizerInfo> authMap = authorizerInfoList.stream().collect(Collectors.toMap(AuthorizerInfo::getAppid, Function.identity()));

        AuthorizerInfo sourceAuthInfo = authMap.get(appId);
        if (ObjectUtil.isNull(sourceAuthInfo)) {
            return new BaseResult().error("找不到公众号信息");
        }
        String accountId = sourceAuthInfo.getAccountId();
        localLog.info("原始accountId: {}", accountId);

        // 找到号下面的所有的客服素材
        List<CustomerGraphicsDelay> sourceCustomerList = super.list(new QueryWrapper<CustomerGraphicsDelay>().eq("app_id", appId));
        List<Long> sourceMainIdList = sourceCustomerList.stream().map(CustomerGraphicsDelay::getId).collect(Collectors.toList());
        // 获取原始链接素材
        List<ReferralEntity> referralEntityList = referralEntityService.list(new QueryWrapper<ReferralEntity>().in("material_graphics_id", sourceMainIdList));
        Map<Long, List<ReferralEntity>> referralGroupMap = referralEntityList.stream().collect(Collectors.groupingBy(ReferralEntity::getMaterialGraphicsId));

        // 遍历处理
        HashSet<String> storeTypeKeySet = CollectionUtil.newHashSet(sourceAuthInfo.getStoreType());
        List<CommonOptionResponseVO> storeTypeList = kanbanCommonMapper.getStoreTypeEntity(storeTypeKeySet);
        // 这里只有一个
        String storeTypeName = storeTypeList.get(0).getName();
        localLog.info("当前复用书城: {}", storeTypeName);
        sourceAuthInfo.setStoreTypeName(storeTypeName);

        for (String targetAppId : targetAppList) {

            // 构造目标公众号的信息
            AuthorizerInfo targetAuthInfo = authMap.get(targetAppId);

            if (ObjectUtil.isNull(targetAuthInfo)) {
                localLog.info("appId: {} 找不到对应公众号", targetAppId);
                // 执行下一个公众号
                continue;
            }
            targetAuthInfo.setStoreTypeName(storeTypeName);

            // 遍历要复用的素材
            for (CustomerGraphicsDelay item : sourceCustomerList) {
                // 设置所属链接
                item.setBelongReferralList(referralGroupMap.get(item.getId()));
                // 为公众号设置书城名
                item.setAuthorizerInfo(sourceAuthInfo);

                // 执行复用

            }

        }
        return null;
    }

    @Override
    public GenericsResult<List<AuthInfoVO>> getAuthList(String keyword) {
        List<AuthInfoVO> authList = super.baseMapper.getAuthList(keyword);
        return new GenericsResult<>(authList);
    }

    @Override
    public GenericsResult<List<CommonOptionResponseVO>> getTimeIntervalList() {
        List<CommonOptionResponseVO> timeIntervalList = super.baseMapper.getTimeIntervalList();
        return new GenericsResult<>(timeIntervalList);
    }
}

