package com.yaoyaozw.customer.constants;

import cn.hutool.core.util.ObjectUtil;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/28 20:09
 */
public class CustomerCommonConstant {

    public final static Integer PERMISSION_OPENING_ROLE_LEVEL = 3;

    public final static BigDecimal THOUSAND_BIG_DECIMAL = new BigDecimal(1000);

    public final static String CROWD_HUMAN_NUN_REDIS_KEY = "crowdHumanNum";

    public final static String STORE_NAME_YANG_GUANG = "YANG_GUANG";
    public final static String STORE_NAME_ZHANG_ZHONG_YUN = "ZHANG_ZHONG_YUN";
    public final static String STORE_NAME_YUE_WEN = "YUE_WEN";
    public final static String STORE_NAME_TOMATO = "TOMATO";

    public final static String ERROR_LABEL = "error";

    public final static List<Integer> REPLACE_LINK_NEWS_TYPE_LIST = Arrays.asList(1, 2, 3, -1);

    public final static List<Integer> REMOTE_LINK_NEWS_TYPE_LIST = Arrays.asList(1, 2, 3);

    public final static List<Integer> COMMON_NEWS_TYPE_LIST = Collections.singletonList(4);

    public final static String YW_LINK_LIMIT_REDIS_KEY = "YW_REFERRAL";
    public final static String YANG_GUANG_ACCESS_LIMIT_REDIS_KEY = "YG_ACCESS_LIMIT_NUM";


    public final static Integer BOOK_NEWS_TYPE = 1;
    public final static String BOOK_NEWS_TYPE_NAME = "推广";
    public final static String BOOK_NEWS_TYPE_NAME_MODEL = "系统-客服-{newsType}-{accountNickName}-{storeType}-{currentDate}-{bookName}";

    public final static Integer ACTIVITY_NEWS_TYPE = 2;
    public final static String ACTIVITY_NEWS_TYPE_NAME = "活动";
    public final static String ACTIVITY_NEWS_TYPE_NAME_MODEL = "系统-客服-{newsType}-{accountNickName}-{storeType}-{currentDate}-充{recharge}送{gift}";

    public final static String CUSTOMER_TEXT_LINK_TEMPLATE = "<a href=\"{url}-\" style='color: blue'>{content}</a>";

    public final static String CUSTOMER_TEXT_URL_PLACEHOLDER = "{url}-";
    public final static String CUSTOMER_TEXT_CONTENT_PLACEHOLDER = "{content}";
    public final static String H5_STYLE_CODE = " style='color: blue'";

    public final static Integer USUAL_LINK_NEWS_TYPE = 3;
    public final static String USUAL_LINK_NEWS_TYPE_NAME = "常用";

    public final static String CUSTOMER_TYPE_VALUE_GRAPHICS = "news";

    public final static String CUSTOMER_TYPE_VALUE_TEXT = "text";

    public final static String CUSTOMER_TYPE_NAME_GRAPHICS = "图文";

    public final static String CUSTOMER_TYPE_NAME_TEXT = "文本";

    public final static Integer SEND_STATUS_WAITING = 0;

    public final static Integer SEND_STATUS_LINK_GETTING = 1;

    public final static Integer SEND_STATUS_LINK_FINISH = 2;

    public final static Integer SEND_STATUS_ACTIVE = 9;

    public final static Integer SEND_STATUS_FINISHED = 10;

    public final static Integer SEND_STATUS_LINK_ERROR = 3;

    public final static Integer SEND_STATUS_SENT_FAIL = 4;


    public static String getCustomerType(String type) {
        if (ObjectUtil.isNull(type)) {
            return null;
        }
        if (type.equals(CUSTOMER_TYPE_VALUE_GRAPHICS)) {
            return CUSTOMER_TYPE_NAME_GRAPHICS;
        }
        if (type.equals(CUSTOMER_TYPE_VALUE_TEXT)) {
            return CUSTOMER_TYPE_NAME_TEXT;
        }
        return type;
    }

    public static String getNewsTypeName(Integer code) {
        if (ObjectUtil.isNull(code)) {
            return null;
        }
        if (code.equals(BOOK_NEWS_TYPE)) {
            return BOOK_NEWS_TYPE_NAME;
        }
        if (code.equals(ACTIVITY_NEWS_TYPE)) {
            return ACTIVITY_NEWS_TYPE_NAME;
        }
        if (code.equals(USUAL_LINK_NEWS_TYPE)) {
            return USUAL_LINK_NEWS_TYPE_NAME;
        }
        return null;
    }

    public static String getLinkNameModel(Integer code) {
        if (ObjectUtil.isNull(code)) {
            return null;
        }
        if (code.equals(BOOK_NEWS_TYPE)) {
            return BOOK_NEWS_TYPE_NAME_MODEL;
        }
        if (code.equals(ACTIVITY_NEWS_TYPE)) {
            return ACTIVITY_NEWS_TYPE_NAME_MODEL;
        }

        return null;
    }

}
