package com.yaoyaozw.customer.vo.crowd;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.constants.CrowdPackageCommonConstant;
import com.yaoyaozw.customer.entity.CrowdPackage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/19 17:44
 */
@Data
@ApiModel("人群包详情页回显实体")
@NoArgsConstructor
public class CrowdPackageDetailVO implements Serializable {

    @ApiModelProperty("人群包主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long packageId;

    @ApiModelProperty("人群包名")
    private String packageName;

    @ApiModelProperty("活跃时间左边界")
    private Double activeTimeMin;

    @ApiModelProperty("活跃时间右边界")
    private Double activeTimeMax;

    /**
     * 关注时间左边界
     */
    private Integer followTimeMin;

    /**
     * 关注时间右边界
     */
    private Integer followTimeMax;

    @ApiModelProperty("关注时间-开始")
    private String followDateStart;

    @ApiModelProperty("关注时间-结束")
    private String followDateEnd;

    @ApiModelProperty("已配置的人群包条件")
    private List<CrowdPackageConditionMatchVO> conditionList;

    public CrowdPackageDetailVO(CrowdPackage byId) {
        this.packageId = byId.getId();
        this.packageName = byId.getPackageName();
        this.followTimeMin = byId.getFollowTimeMin();
        this.followTimeMax = byId.getFollowTimeMax();
        // 定义日期格式化工具
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        // 转换 followDateStart
        if (byId.getFollowDateStart() != null) {
            this.followDateStart = dateFormat.format(byId.getFollowDateStart());
        } else {
            this.followDateStart = null;
        }
        // 转换 followDateEnd
        if (byId.getFollowDateEnd() != null) {
            this.followDateEnd = dateFormat.format(byId.getFollowDateEnd());
        } else {
            this.followDateEnd = null;
        }

        if (ObjectUtil.isNotNull(byId.getActiveTimeMin())) {
            this.activeTimeMin = byId.getActiveTimeMin().doubleValue() / CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
        }
        if (ObjectUtil.isNotNull(byId.getActiveTimeMax())) {
            this.activeTimeMax = byId.getActiveTimeMax().doubleValue() / CrowdPackageCommonConstant.HOUR_TO_MILLION_RATE;
        }
    }
}
