package com.yaoyaozw.customer.vo.crowd;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/19 17:44
 */
@Data
@ApiModel("人群包详情页回显实体")
public class CrowdPackageDetailVO implements Serializable {

    @ApiModelProperty("人群包主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long packageId;

    @ApiModelProperty("人群包名")
    private String packageName;

    @ApiModelProperty("已配置的人群包条件")
    private List<CrowdPackageConditionVO> conditionList;

}
