package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.dto.follow.FollowReplyMultiNewsCreateDTO;
import com.yaoyaozw.customer.entity.CustomerFollowReplyMultiNews;
import com.yaoyaozw.customer.vo.AuthInfoVO;

import java.util.List;

/**
 * @author darker
 * @date 2023/11/1 14:28
 */
public interface CustomerFollowReplyMultiNewsService extends IService<CustomerFollowReplyMultiNews> {

    /**
     * 保存关回多图文的图文列表
     * @param replyId 关回配置的主键Id
     * @param accountEntity 公众号
     * @param multiNewsList 图文列表
     */
    void saveFollowReplyMultiNews(Long replyId, AuthInfoVO accountEntity, List<FollowReplyMultiNewsCreateDTO> multiNewsList);

    void putMaterialToRedis(String appId, List<? extends CustomerFollowReplyMultiNews> entityList);

}
