package com.yaoyaozw.customer.common;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * api结果
 *
 * @author Darker
 * @date 2022/8/14 13:32
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GenericsResult<T> extends BaseResult{

    public GenericsResult(Boolean success, String message) {
        if (success) {
            success();
        } else {
            error();
        }
        this.message = message;
        this.data = null;
    }

    public GenericsResult(Boolean success, String message, T data) {
        if (success) {
            success();
        } else {
            error();
        }
        this.message = message;
        this.data = data;
    }

    public GenericsResult(String message, T data) {
        success();
        this.message = message;
        this.data = data;
    }

    public GenericsResult(T data) {
        success();
        this.data = data;
    }

    /**
     * 返回数据
     */
    private T data;


}
