package com.yaoyaozw.customer.vo.follow;

import cn.hutool.core.bean.BeanUtil;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.entity.CustomerFollowReplyMultiNews;
import com.yaoyaozw.customer.entity.ReferralEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author darker
 * @date 2023/11/2 15:28
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FollowReplyMultiNewsVO extends CustomerFollowReplyMultiNews implements Serializable {

    private CommonReferralBody referralBody;

    @Override
    public void setReferralEntity(ReferralEntity referralEntity) {
        super.setReferralEntity(referralEntity);
        if (referralEntity != null) {
            CommonReferralBody commonReferralBody = new CommonReferralBody();
            BeanUtil.copyProperties(referralEntity, commonReferralBody);
            this.referralBody = commonReferralBody;
        }
    }
}
