package com.yaoyaozw.customer.publisher;

import com.yaoyaozw.customer.dto.AcquisitionExceptionHandleParam;
import com.yaoyaozw.customer.event.AcquisitionExceptionEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author eumenides
 * @time 2024/12/13 17:44
 */
@Slf4j
@Component
public class AcquisitionExceptionEventPublisher {

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    public void publishAcquisitionExceptionEvent(AcquisitionExceptionHandleParam source) {
        log.info("准备替换公众号：{} 获客链接：{} 为：{}", source.getAuthorizerInfo().getNickName(), source.getFromPath(), source.getToPath());
        applicationEventPublisher.publishEvent(new AcquisitionExceptionEvent(source));
    }



}
