import com.yaoyaozw.customer.CustomerServiceApplication;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.mapper.RegisterUserEntityMapper;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.vo.kanban.CommonCostSetupVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;


import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author wgh
 * @date 2022/10/17 19:20
 */
@SpringBootTest(classes = CustomerServiceApplication.class)
@RunWith(SpringRunner.class)
public class test {
    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;

    @Autowired
    private RegisterUserEntityMapper registerUserEntityMapper;

    @Autowired
    private RegisterUserEntityService registerUserEntityService;


    @Test
    public void updateSetupId(){

        List<AuthorizerInfo> appidList = registerUserEntityMapper.existAppid();
        if (appidList!=null){
            for (AuthorizerInfo authInfo : appidList) {
                String appid = authInfo.getAppid();
                System.err.println("开始:"+authInfo.getNickName());
                List<CommonCostSetupVo> wechatCostSetup = kanbanCommonMapper.getWechatCostSetup(appid);

                if (wechatCostSetup!=null){

                    Map<Date, Long> setupMap = wechatCostSetup.stream().collect(Collectors.toMap(CommonCostSetupVo::getCostDate, CommonCostSetupVo::getId, (v1, v2) -> v1));

                    List<RegisterUserEntity> allUser = registerUserEntityMapper.findAllUserWithoutSetupId(appid);

                    System.err.println("总计:"+allUser.size());

                        for (RegisterUserEntity user :allUser){

                            user.setSetupId(setupMap.get( user.getFormatDate()) );
                        }

                        registerUserEntityService.updateBatchById(allUser);

                        System.err.println("====>完成："+authInfo.getNickName());
                }
            }
        }
    }
}
