package com.yaoyaozw.customer.dto.integration;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 获取数据DTO
 */
@Data
public class IntegrationRequestDTO implements Serializable {

    private static final long serialVersionUID = -9128287125234317100L;
    /**
     * 获取数据的事件
     * 例如: 2021-04-01 00:00:00
     */
    private Date requestDate;

    /**
     * 数据频次
     * 例如: 实时
     */
    private Integer dataFrequency;

    /**
     * 获取的数据类型
     * 渠道账号, 用户数据, 订单, 消耗
     * 例如: 渠道账号
     */
    private String dataType;


}
