package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;

@Data
public class CompanyAcquisitionLink implements Serializable {
    /**
     * 主键Id
     */
    @Id
    @TableId(value = "id", type = IdType.AUTO)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 公众号AppID
     */
    private String authAppId;

    /**
     * 企业Id
     */
    private Long companyId;

    /**
     * 链接Id
     */
    private String linkId;

    /**
     * 链接名称
     */
    private String linkName;

    /**
     * 链接地址
     */
    private String linkUrl;

    /**
     * 链接创建时间
     */
    private Date createTime;

    /**
     * 是否无需验证
     */
    private Integer skipVerify;

    /**
     * 链接绑定用户列表Json
     */
    private String userListJson;

    /**
     * OPERATE：运营；PUTTING：投放
     */
    private String type;

    /**
     * 状态
     */
    private Integer status;

    @TableLogic
    private Integer isDeleted;

    /**
     *
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    /**
     *
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    private static final long serialVersionUID = 1L;
}