package com.yaoyaozw.customer.vo.crowd;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/19 17:37
 */
@Data
@ApiModel("接口执行生成的主键")
@NoArgsConstructor
public class CrowdPackageCommonIdVO implements Serializable {

    @ApiModelProperty("人群包主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long packageId;

    @ApiModelProperty("人群包与条件关联主键")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long linkedId;

    @ApiModelProperty("新增的条件描述")
    private String conditionDescription;

    public CrowdPackageCommonIdVO(Long packageId, Long linkedId) {
        this.packageId = packageId;
        this.linkedId = linkedId;
    }
}
