package com.yaoyaozw.customer.service;

import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author darker
 * @date 2022/9/28 19:01
 */
public interface CustomerServiceCommonService {

    /**
     * 得到从静态条件设置id列表
     *
     * @param expressList 表达列表
     * @return {@link List}<{@link Long}>
     */
    Set<Long> getSetupIdListFromStaticCondition(List<String> expressList);

    /**
     * 获取存储列表
     *
     * @return {@link GenericsResult}<{@link CommonOptionResponseVO}>
     */
    GenericsResult<List<CommonOptionResponseVO>> getStoreList();

    /**
     * 把封面图片列表
     *
     * @return {@link GenericsResult}<{@link List}<{@link CommonOptionResponseVO}>>
     */
    GenericsResult<List<CommonOptionResponseVO>> getCoverPicList();

    /**
     * 让常见链接列表
     *
     * @return {@link GenericsResult}<{@link List}<{@link CommonOptionResponseVO}>>
     */
    GenericsResult<List<CommonOptionResponseVO>> getCommonLinkList();

    /**
     * 让常见链接列表
     *
     * @param accountSet 帐户设置
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getAuthInfoList(Set<String> accountSet);


    /**
     * 获取书城常用链接映射
     *
     * @param currentKey 当前key
     * @return {@link Map}<{@link String}, {@link Map}<{@link String}, {@link String}>>
     */
    Map<String, Map<String, String>> storeCommonLinkMap(String currentKey);

}
