package com.yaoyaozw.customer.dto;

import lombok.Data;

import java.util.List;

/**
 * @Author: Dwl
 * @Date: 2024/09/09/12:17
 * @ClassName: WoComDTO
 * @Version: V3.2.0
 * @Description: 文本类型请求模型
 */
@Data
public class WeChatTextDTO {
    private static final String TEXT = "text";
    private String msgtype = TEXT;
    private Text text;

    public WeChatTextDTO cover(String content, List<String> openList, List<String> openIdList) {
        WeChatTextDTO woComTextDTO = new WeChatTextDTO();
        this.text = new Text();
        this.text.setContent(content);
        if (openList != null && !openList.isEmpty()) {
            this.text.setMentioned_mobile_list(openList);
        }
        if (openIdList != null && !openIdList.isEmpty()) {
            this.text.setMentioned_list(openIdList);
        }
        woComTextDTO.setText(this.text);
        return woComTextDTO;
    }

    @Data
    private static class Text {
        private String content;
        private List<String> mentioned_mobile_list;
        private List<String> mentioned_list;
    }
}
