package com.yaoyaozw.customer.configs;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.yaoyaozw.customer.components.TokenManager;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author 10626
 */
@Component
@Slf4j
public class MyMetaObjectHandler implements MetaObjectHandler {
    @Autowired
    private TokenManager tokenManager;
    @Override
    public void insertFill(MetaObject metaObject) {
        Long userId = tokenManager.getUserIdFromToken();
        if (ObjectUtil.isNotNull(userId)){
            String userIdStr = userId.toString();
            this.setFieldValByName("gmtModifiedUser", userIdStr, metaObject);
            this.setFieldValByName("gmtCreateUser", userIdStr, metaObject);

            this.setFieldValByName("modifiedUser", userId, metaObject);
            this.setFieldValByName("createUser", userId, metaObject);
        }
        this.setFieldValByName("gmtCreate", new Date(), metaObject);
        this.setFieldValByName("gmtModified", new Date(), metaObject);
        this.setFieldValByName("isDeleted", 0, metaObject);


    }

    @Override
    public void updateFill(MetaObject metaObject) {
        this.setFieldValByName("gmtModified",new Date(),metaObject);
        Long userId = tokenManager.getUserIdFromToken();
        if (ObjectUtil.isNotNull(userId)){
            this.setFieldValByName("gmtModifiedUser", userId.toString(), metaObject);
            this.setFieldValByName("modifiedUser", userId, metaObject);
        }
    }
}
