package com.yaoyaozw.customer.dto.customer;

import cn.hutool.core.util.ObjectUtil;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/15 11:14
 */
@Data
@ApiModel("延时客服保存实体")
public class CustomerDelaySaveDTO implements Serializable {

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("公众号appId")
    private String appId;

    @ApiModelProperty("客服消息名称")
    private String name;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String type;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String extendTitle;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String coverUrl;

    @ApiModelProperty("文本内容")
    private String content;

    @ApiModelProperty("发文序号")
    private Integer postSort;

    @ApiModelProperty("发文间隔时间")
    private Long timeInterval;

    @ApiModelProperty("已支付、未支付")
    private Integer isPay;

    @ApiModelProperty("消息内容实体")
    private CommonReferralBody customerReferralDto;

    private Integer hour;

    private Integer minute;

    public Long getTimeInterval() {
        long stamp = 0L;
        if (ObjectUtil.isNotNull(this.hour)) {
            stamp += this.hour * 1000 * 60 * 60;
        }
        if (ObjectUtil.isNotNull(this.minute)) {
            stamp += this.minute * 1000 * 60;
        }
        return stamp == 0 ? null : stamp;
    }
}
