package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.SnowflakeComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerMessageMiniProgramSaveDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.mapper.CustomerGraphicsMapper;
import com.yaoyaozw.customer.service.CustomerGraphicsMiniProgramService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.vo.customer.CustomerMessageDetailVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerGraphicsMiniProgramServiceImpl extends ServiceImpl<CustomerGraphicsMapper, CustomerGraphics> implements CustomerGraphicsMiniProgramService {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CustomerGraphicsMiniProgramServiceImpl.class);

    @Autowired
    private TokenManager tokenManager;

    @Autowired
    private SnowflakeComponent snowflakeComponent;

    @Autowired
    private ReferralEntityService referralEntityService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResult insertCustomerMessage(CustomerMessageMiniProgramSaveDTO saveDto) {
        // 主体数据
        LOCAL_LOG.info("处理主体数据");
        CustomerGraphics customerGraphics = new CustomerGraphics();
        BeanUtil.copyProperties(saveDto, customerGraphics);
        customerGraphics.initOperateInfo(tokenManager.getUserIdFromToken(), ObjectUtil.isNull(saveDto.getId()));
        if (ObjectUtil.isNull(customerGraphics.getId())) {
            long id = snowflakeComponent.snowflakeId();
            customerGraphics.setId(id);
        }
//        // 设置链接数
//        if (CustomerCommonConstant.REMOTE_LINK_NEWS_TYPE_LIST.contains(saveDto.getCustomerReferralDto().getNewsType())) {
//            customerGraphics.setReferralSize(1);
//        }
        super.saveOrUpdate(customerGraphics);

        // 处理活动数据
        ReferralEntity referralEntity = new ReferralEntity();
        BeanUtil.copyProperties(saveDto, referralEntity);
        referralEntity.setMaterialGraphicsId(customerGraphics.getId());
        // 获取name模板
        String nameModel = CustomerCommonConstant.getLinkNameModel(referralEntity.getNewsType());
        LOCAL_LOG.info("获取name模板: {}", nameModel);
        if (StringUtils.isNotBlank(nameModel)) {
            referralEntity.setName(nameModel);
        }

        // 保存链接数据
        referralEntityService.saveOrUpdate(referralEntity);
        return new BaseResult().success();
    }

    @Override
    public GenericsResult<CustomerMessageMiniProgramSaveDTO> getCustomerTextDetail(Long id) {
        // 获取主体数据
        CustomerGraphics customerGraphics = super.getById(id);
        if (ObjectUtil.isNull(customerGraphics)) {
            return new GenericsResult<>(false, "找不到主体数据");
        }
        CustomerMessageMiniProgramSaveDTO miniProgramDTO = new CustomerMessageMiniProgramSaveDTO();
        BeanUtil.copyProperties(customerGraphics, miniProgramDTO);
        miniProgramDTO.setPostTime(customerGraphics.getPostTimeStr());

//         获取链接数据
        ReferralEntity referralEntity = referralEntityService.getOne(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", id).isNull("account_id"));

        if (ObjectUtil.isNull(referralEntity)) {
            return new GenericsResult<>(false, "找不到链接数据");
        }
        miniProgramDTO.setMpAppId(referralEntity.getMpAppId());
        miniProgramDTO.setMpTitle(referralEntity.getMpTitle());
        miniProgramDTO.setMpPath(referralEntity.getMpPath());

        return new GenericsResult<>(miniProgramDTO);
    }
}
