package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.DelayCustomerQueryDTO;
import com.yaoyaozw.customer.dto.customer.DelayCustomerSaveDTO;
import com.yaoyaozw.customer.vo.customer.DelayCustomerItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口")
@RestController
@RequestMapping("/delay-customer-service")
public class DelayCustomerController {



    @ApiOperation("新增")
    @PostMapping("/insert")
    public BaseResult insertCrowdPackage(@RequestBody DelayCustomerSaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("编辑")
    @PostMapping("/edit")
    public BaseResult updateCrowdPackage(@RequestBody DelayCustomerSaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<DelayCustomerItemVO>> pageList(@RequestBody DelayCustomerQueryDTO queryDto) {
        return new GenericsResult<>(new ArrayList<>());
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCrowdPackage(@PathVariable("id") Long id) {
        return new BaseResult().success();
    }


}
