package com.yaoyaozw.customer.vo.customer;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/16 10:45
 */

@Data
@EqualsAndHashCode(of = "id")
public class CustomerDelayItemVO implements Serializable {

    private static final long serialVersionUID = -4630777409975737444L;

    private Long id;
    /**
     * appid
     */
    private String appId;

    /**
     * 发送序列
     */
    private Integer postSort;

    /**
     * 间隔时间
     */
    private Long timeInterval;


    /**
     * 类型
     */
    private String type;


    /**
     * 推广标题
     */
    private String extendTitle;


    /**
     * 文本内容
     */
    private String content;

    /**
     * 图文原文链接
     */
    private String sourceUrl;

    /**
     * 图片
     */
    private String coverUrl;

    /**
     * 送达人数
     */
    private Integer sendNum;

    /**
     * 计数锁
     */
    private final Object LOCK;

    public CustomerDelayItemVO() {
        this.LOCK=new Object();
    }

    public void updateSendNum(){
        synchronized (LOCK){
            this.sendNum++;
        }
    }
}
