package com.yaoyaozw.customer.controller;

import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayGraphicsDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口")
@RestController
@RequestMapping("/customer-service/delay/graphics")
public class CustomerDelayGraphicsController {

    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;


    @ApiOperation("新增")
    @PostMapping("/insert")
    public BaseResult insertCustomerDelay(@RequestBody CustomerDelaySaveDTO saveDto) {
        return customerGraphicsDelayService.insertCustomerDelay(saveDto);
    }

    @ApiOperation("获取详情")
    @GetMapping("/detail/{id}")
    public GenericsResult<CustomerDelayGraphicsDetailVO> getCustomerDelayDetail(@PathVariable("id") Long id) {
        return customerGraphicsDelayService.getCustomerDelayDetail(id);
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<PageInfo<CustomerDelayListVO>> pageList(@RequestBody CustomerDelayQueryDTO queryDto) {
        return customerGraphicsDelayService.pageList(queryDto);
    }

    @ApiOperation("获取已生成客服的公众号列表")
    @GetMapping("/getExistCustomerAccount")
    public GenericsResult<List<AuthInfoVO>> getExistCustomerAccount(@RequestParam(required = false) String keyword) {
        return customerGraphicsDelayService.getExistCustomerAccount(keyword);
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCustomerDelay(@PathVariable("id") Long id) {
        return customerGraphicsDelayService.removeCustomerDelay(id);
    }

    @ApiOperation("批量删除")
    @PostMapping("/removeBatch")
    public BaseResult removeBatch(@RequestBody List<Long> idList) {
        return customerGraphicsDelayService.removeBatch(idList);
    }

    @ApiOperation("复用")
    @PostMapping("/copy")
    public BaseResult copy(@RequestParam String appId, @RequestBody List<String> targetAppList) {
        return customerGraphicsDelayService.copy(appId, targetAppList);
    }

    @ApiOperation("所有公众号")
    @GetMapping("/getAuthList")
    public GenericsResult<List<AuthInfoVO>> getAuthList(@RequestParam(required = false) String keyword) {
        return customerGraphicsDelayService.getAuthList(keyword);
    }

    @ApiOperation("时间间隔")
    @GetMapping("/getTimeIntervalList")
    public GenericsResult<List<CommonOptionResponseVO>> getTimeIntervalList() {
        return customerGraphicsDelayService.getTimeIntervalList();
    }

}
