package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.MaterialMenuConfig;
import com.yaoyaozw.customer.mapper.MaterialMenuConfigMapper;
import com.yaoyaozw.customer.service.MaterialMenuConfigService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: Dwl
 * @Date: 2024/05/30/11:14
 * @ClassName: MaterialMenuConfigServiceImpl
 * @Version: V3.2.0
 * @Description:
 */
@Slf4j
@Service
public class MaterialMenuConfigServiceImpl extends ServiceImpl<MaterialMenuConfigMapper, MaterialMenuConfig> implements MaterialMenuConfigService {
    @Override
    public void removeById(List<Long> authIds) {
        LambdaQueryWrapper<MaterialMenuConfig> queryWrapper = new LambdaQueryWrapper<MaterialMenuConfig>().in(MaterialMenuConfig::getAuthId, authIds);
        int count = this.baseMapper.delete(queryWrapper);
        log.info("删除目标公众号配置_{}", count);
    }
}
