package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;

import java.util.List;


/**
 * @author Admin
 * @date 2022/10/08
 */
public interface ReferralEntityService extends IService<ReferralEntity> {

    /**
     * 物理删除素材元素
     *
     * @param sourceId 素材主体ID
     * @param extraCondition 特殊条件表达式
     */
    void ultimateDeleteReferrals(Long sourceId, String extraCondition);

    /**
     * 物理删除素材元素
     *
     * @param sourceIdList 素材主体ID
     * @param extraCondition 特殊条件表达式
     */
    void ultimateDeleteReferralsBatch(List<Long> sourceIdList, String extraCondition);

    /**
     * 根据客服id找链接
     * @param graphicsId 客服主体id
     * @return
     */
    List<ReferralEntityVo> findReferralByCustomerGraphicsId(Long graphicsId);
}
