package com.yaoyaozw.customer.dto;

import com.yaoyaozw.customer.entity.AuthorizerInfo;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
public class AcquisitionExceptionHandleParam implements Serializable {

    /**
     * 公众号信息
     */
    private AuthorizerInfo authorizerInfo;

    /**
     * 被替换的链接地址
     */
    private String fromPath;

    /**
     * 替换的链接地址
     */
    private String toPath;

    public AcquisitionExceptionHandleParam(AuthorizerInfo authorizerInfo, String fromPath, String toPath) {
        this.authorizerInfo = authorizerInfo;
        this.fromPath = fromPath;
        this.toPath = toPath;
    }
}
