package com.yaoyaozw.customer.vo.crowd;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.entity.CrowdPackageCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/22 18:09
 */
@Data
@ApiModel("人群包条件匹配实体")
public class CrowdPackageConditionMatchVO implements Serializable {

    /**
     * 主键
     */
    @ApiModelProperty("匹配主键")
    private Long id;

    /**
     * 人群包ID
     */
    @ApiModelProperty("人群包ID")
    private Long packageId;

    /**
     * 条件表主键ID
     */
    @ApiModelProperty("条件表主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long conditionId;

    private CrowdPackageCondition conditionEntity;

    /**
     * 条件描述
     */
    @ApiModelProperty("条件描述")
    private String operatorDescription;

}
