package com.yaoyaozw.customer.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.springframework.data.annotation.Id;

/**
 * 客户关键字
 *
 * @author darker
 * @date 2023/03/20
 */
@Data
@TableName("customer_keyword")
public class CustomerKeyword implements Serializable {
    /**
     * 主键
     */
    @Id
    @TableId(value = "id", type = IdType.ID_WORKER)
    private Long id;

    /**
     * 公众号appid
     */
    @TableField("appid")
    private String appid;

    /**
     * 关键词
     */
    @TableField("keyword")
    private String keyword;

    /**
     * 类型
     */
    @TableField("type")
    private String type;

    /**
     * 原始文件地址
     */
    @TableField("origin_media_url")
    private String originMediaUrl;

    /**
     * 腾讯media地址
     */
    @TableField("tx_media_url")
    private String txMediaUrl;

    /**
     * 腾讯mediaId
     */
    @TableField("tx_media_id")
    private String txMediaId;

    /**
     * 图文标题
     */
    @TableField("extend_title")
    private String extendTitle;

    /**
     * 图文描述
     */
    @TableField("extend_desc")
    private String extendDesc;

    /**
     * 跳转链接
     */
    @TableField("source_url")
    private String sourceUrl;

    /**
     * H5文本
     */
    @TableField("content")
    private String content;

    /**
     * 状态
     */
    @TableField("status")
    private Integer status;

    /**
     * 逻辑删除
     */
    @TableField(value = "is_deleted", fill = FieldFill.INSERT)
    @TableLogic
    private Integer isDeleted;

    /**
     * 创建人
     */
    @TableField(value = "create_user", fill = FieldFill.INSERT)
    private Long createUser;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    /**
     * 更新人
     */
    @TableField(value = "modified_user", fill = FieldFill.INSERT_UPDATE)
    private Long modifiedUser;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    @TableField(exist = false)
    private List<ReferralEntity> referralEntityList;

    private static final long serialVersionUID = 1L;
}

