package com.yaoyaozw.customer.security;

import cn.hutool.core.util.ObjectUtil;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/**
 * <p>
 * token管理
 * </p>
 *
 * @author qy
 * @since 2019-11-08
 */
@Component
@Slf4j
public class TokenManager {

    private final static long TOKEN_EXPIRATION = 24 * 60 * 60 * 1000;
    private final static String TOKEN_SINGLE_KEY = "123456";

    public String createToken(String id, String username) {
        return Jwts.builder().setSubject(username).setId(id).setExpiration(new Date(System.currentTimeMillis() + TOKEN_EXPIRATION)).signWith(SignatureAlgorithm.HS512, TOKEN_SINGLE_KEY).compressWith(CompressionCodecs.GZIP).compact();
    }

    public String getUserFromToken(String token) {
        return Jwts.parser().setSigningKey(TOKEN_SINGLE_KEY).parseClaimsJws(token).getBody().getSubject();
    }

    public Long getUserIdFromToken() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (ObjectUtil.isNull(requestAttributes)) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        String token = request.getHeader("token");
        if(StringUtils.isBlank(token)){
            return -1L;
        }
        String userId = Jwts.parser().setSigningKey(TOKEN_SINGLE_KEY).parseClaimsJws(token).getBody().getId();
        return ObjectUtil.isNull(userId) ? null : Long.parseLong(userId);
    }

    public String getUserNameFromToken() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (ObjectUtil.isNull(requestAttributes)) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        String token = request.getHeader("token");
        return Jwts.parser().setSigningKey(TOKEN_SINGLE_KEY).parseClaimsJws(token).getBody().getSubject();
    }

    public String getUserIdFromToken(String token) {
        return Jwts.parser().setSigningKey(TOKEN_SINGLE_KEY).parseClaimsJws(token).getBody().getId();
    }

}
