package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageSaveDTO;
import com.yaoyaozw.customer.dto.customer.DelayCustomerQueryDTO;
import com.yaoyaozw.customer.dto.customer.DelayCustomerSaveDTO;
import com.yaoyaozw.customer.entity.DelayCustomer;
import com.yaoyaozw.customer.service.DelayCustomerService;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口")
@RestController
@RequestMapping("/delay-customer-service")
public class DelayCustomerController {

    @Autowired
    private DelayCustomerService delayCustomerService;


    @ApiOperation("保存")
    @PostMapping("/save")
    public BaseResult saveCrowdPackage(@RequestBody DelayCustomerSaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("编辑")
    @PostMapping("/edit")
    public BaseResult updateCrowdPackage(@RequestBody DelayCustomerSaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<DelayCustomer>> pageList(@RequestBody DelayCustomerQueryDTO queryDto) {
        return new GenericsResult<>(new ArrayList<>());
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCrowdPackage(@PathVariable("id") Long id) {
        return new BaseResult().success();
    }


}
